%%Emily R Barker
%%University of Southampton - QuantMig Research Fellow
%%E.R.Barker@soton.ac.uk
%%Do not use without author's permission
%%If you spot an error, or have any questions, please contact E Barker
%%Barker, E. R. (2021), The decline of East to West European Migration through automation, Working Papers forthcoming, MPRA.
%%Part of Barker E. R. and Bijak J (2021) Uncertainty in Migration Scenarios. QuantMig Project Deliverable D9.2 Data Description. Southampton: University of Southampton. 

function [ys,check] = QuantMig_D92_DSGE_EtW_V1_2_19_Oct_21_steadystate(ys,junk,do_steady_print)
global M_ 

% read out parameters to access them with their name
NumberOfParameters = M_.param_nbr;
for ii = 1:NumberOfParameters
  paramname = deblank(M_.param_names(ii,:));
  eval([ paramname ' = M_.params(' int2str(ii) ');']);
end
% initialize indicator

options=optimset(); % set options for numerical solver
check = 0 ;

rhoap	=	0.7514	;
rhoagp	=	0.7567	;
rhoaap	=	0.7239	;
rhorp	=	0.7209	;
rhopsip	=	0.7173	;
%rhogc	=	0.7334	;
%rhogcf	=	rhogc	;
%rhogx	=	0.6430	;
phibp	=	0.5	;
rhogxh	=	rhogx	;
%rhoXAp  = 0.5 ;
%rhoXAGp  = 0.5 ;
rhopsiagp = 0.5 ;
%rhogmp = 0.5 ;

he_ss = 1.00 ;
hg_ss = 1.00 ;
hm_ss = 1.00 ;
hs_ss = 1.00 ;
betagp    = 0.99;
rg_ss = 1/betagp - 1;
rshock_ss = 0.01 ;
r_ss      = rg_ss + rshock_ss; 
betap     = 1/(1+r_ss); 

%Thetagcep = -1 ;
%Thetagcgp = -1 ;

deltap    = 0.025;%0.1225;
deltagp   = 0.0125;%0.1170 ;
%%Estimated parameters 120521
rhoagp	=	0.7126	;
rhoap	=	0.6884	;
rhogcf	=	0.7389	;
rhogc	=	0.5647	;
rhogmp	=	0.7234	;
rhogx	=	0.5952	;
rhopsip	=	0.6857	;
rhoXAGp	=	0.6439	;
rhoXAp	=	0.6622	;
phixp	=	3.4865	;
thetap	=	1.9914	;
Thetagcep	=	1.0022	;
Thetagcgp	=	1.0444	;


sigmap    = 2;
phip      = 2;    %1/phip is the Frisch labour supply elasticity
phigp = 2 ;
kappaxp   = 1;
bbarp     = 0;
%thetap       = 1.1;
thetastarp   = thetap;
%phixp        = 1; 

asigmap      = 1;

ratioyoye     = 0.10;  
alphaakp = 0.6 ;
xilap        = 230;
xikop        = 230;
Gammaep = 0.5 ;
Gammagp = 0.5 ;
Gammamp = 0.5 ;
Gammasp = 0.5 ;
rhonep = 0.1 ;
rhongp = 0.03 ;
rhonmp = 0.05 ;
rhonsp = 0.05 ;
looverl = 0 ;

%% steady state values


%rhoqq = 0.80 ;
%deltaw = 1 ;
%rhopp = 0.5 ;

varphigg_ss = 0.70;
varphigs_ss = 1-varphigg_ss;
varphiee_ss = 0.70;
varphiem_ss = 1-varphiee_ss;
utildegg_ss = 0.025 ;
utildegs_ss = 0.0500;
utildeee_ss = 0.0500 ;
utildeem_ss = 0.0500 ;

g_ss = 1 ;
gg_ss = 1 ;
ne_ss =  varphiee_ss*(1-utildeee_ss);%0.80 ;
ng_ss =  varphigg_ss*(1-utildegg_ss);%0.65 ;
nm_ss = varphiem_ss*(1-utildeem_ss);%0.10 ;
ns_ss = varphigs_ss*(1-utildegs_ss);%0.30 ;
utildee_ss = 1 - ne_ss - nm_ss ;
utildeg_ss = 1 - ng_ss - ns_ss ;
ue_ss = 1 - (1-rhonep)*ne_ss - (1-rhonmp)*nm_ss ;
ug_ss = 1 - (1-rhongp)*ng_ss - (1-rhonsp)*ns_ss ;
uee_ss = varphiee_ss - (1-rhonep)*ne_ss ;
uem_ss = varphiem_ss - (1-rhonmp)*nm_ss ;
ugg_ss = varphigg_ss - (1-rhongp)*ng_ss ;
ugs_ss = varphigs_ss - (1-rhonsp)*ns_ss ;
me_ss = rhonep*ne_ss ;
mg_ss = rhongp*ng_ss ;
mm_ss = rhonmp*nm_ss ;
ms_ss = rhonsp*ns_ss ;
qve_ss = 0.7 ;
qvg_ss = 0.80 ;
qvm_ss = 0.7 ;
qvs_ss = 0.7 ;

uuee_ss = varphiee_ss*(utildeee_ss);
uuem_ss = varphiem_ss*(utildeem_ss);
uugg_ss = varphigg_ss*(utildegg_ss);
uugs_ss = varphigg_ss*(utildegs_ss);

aleph_ss = 0 ;
nmi_ss = aleph_ss*nm_ss ;
nml_ss = nm_ss - nmi_ss ; 
qobc_ss = 1 - aleph_ss ;
pobc_ss = (1) ;
qq_ss = qobc_ss ;
pp_ss = pobc_ss ;

lmoverl = nm_ss/(nm_ss+ne_ss) ;

lambdae_ss = uee_ss/ue_ss ;


%utildeem_ss = utildee_ss*(1-lambdae_ss) ;
%utildeee_ss = utildee_ss*lambdae_ss ;
%utildegg_ss = utildeg_ss*lambdag_ss ;
%utildegs_ss = utildeg_ss*(1-lambdag_ss) ;

% uee_ss = lambdae_ss*ue_ss ;
% uem_ss = (1-lambdae_ss)*ue_ss ;
% ugg_ss = lambdag_ss*ug_ss ;
% ugs_ss = (1-lambdag_ss)*ug_ss ;

ve_ss = me_ss/qve_ss ;
vg_ss = mg_ss/qvg_ss ;
vm_ss = mm_ss/qvm_ss ;
vs_ss = ms_ss/qvs_ss ;

zetae_ss = (me_ss)/(uee_ss) ;
zetag_ss = (mg_ss)/(ugg_ss) ;
zetam_ss = (mm_ss)/(uem_ss) ;
zetas_ss = (ms_ss)/(ugs_ss) ;

aep = (me_ss)/(uee_ss^(Gammaep)*ve_ss^(1-Gammaep));
agp = (mg_ss)/(ugg_ss^(Gammagp)*vg_ss^(1-Gammagp)); 
amp = (mm_ss)/(uem_ss^(Gammamp)*vm_ss^(1-Gammamp)); 
asp = (ms_ss)/(ugs_ss^(Gammasp)*vs_ss^(1-Gammasp)); 


qvmigp = nm_ss + uem_ss ;

thetae_ss = ve_ss/uee_ss ;
thetag_ss = vg_ss/ugg_ss ;
thetam_ss = vm_ss/uem_ss ;
thetas_ss = vs_ss/ugs_ss ;

%%OLD
%sharestartbg     = 0.001;
%kappacompp       = 0.005;

sharestartbg     = 0.001;
kappacompp       = 0.025;



psie_ss = 1 ;


tq_ss     =  (1)/(kappaxp);
tqg_ss    =  (1)/(kappaxp);
tqa_ss    =  (1)/(kappaxp);

chii = 0.10 ;


varrho_ss = 0 ;
Phiep = 0.25 ;
Phiop = 0.25 ; 
%kappakp = 0.2000 ;

hrse_ss = (ne_ss)*he_ss ; %
hrsg_ss = (ng_ss)*hg_ss ; %+ns_ss
hrss_ss = ns_ss*hs_ss ;
lm_ss = nm_ss*hm_ss ; %lmoverl*hrse_ss ; 

le_ss = (1 - looverl)*hrse_ss ; %-lmoverl
la_ss = looverl*hrse_ss ;

rk_ss     =  1/betap-(1-deltap); %

%%%%%%%%%%%%%%%%%%%%
%%Automation
%%%%%%%%%%%%%%%%%%%%
PsiXA_ss = 1 ;

rhoAep = 0.08 ;

Ae_ss = 0.042;
qae_ss = (Ae_ss*PsiXA_ss*rhoAep)/((1-qve_ss)*ve_ss) ;
nue_ss = qae_ss*(1-qve_ss)*ve_ss ; % rhoAep*Ae_ss

etaaep = 1;
etaeep = 1;

%workings
% eoskle = 0.6 ;
% sigkp = (eoskle-1)/eoskle ;
% eosala = 1 ;
% sigap = (eosala-1)/eosala ;
% eoska = 2.1;
% %alphaep = (eoska-1)/eoska ;
% alephep = 0.4 ;
% lamep = 0.3 ;
% lamap = 0.4;
% siglae = 0.5^(1/8) ;
aa_ss = 0.7 ;
psiae_ss =1;
ae_ss      =  1;

alphaep = 0.25 ;
%%%Try to solve with aa_ss 

% F = @(x) [rk_ss -  alephep*lamep^(1/eoskle)*ae_ss*(alephep* (lamep^(1/eoskle)*x(1)^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp) + (1-alephep)*x(2)*(lamap*Ae_ss*psiae_ss + (1-lamap)*la_ss)^(alphaep))^(1/alphaep-1)* (lamep^(1/eoskle)*x(1)^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp-1)*x(1)^(sigkp-1) ;
% alephep*(1-lamep)^(1/eoskle)*ae_ss*(alephep* (lamep^(1/eoskle)*x(1)^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp) + (1-alephep)*x(2)*(lamap*Ae_ss*psiae_ss + (1-lamap)*la_ss)^(alphaep))^(1/alphaep-1)* (lamep^(1/eoskle)*x(1)^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp-1)*le_ss^(sigkp-1) -(1-alephep)*(1-lamap)^(1/eosala)*x(2)*ae_ss*(alephep* (lamep^(1/eoskle)*x(1)^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp) + (1-alephep)*x(2)*(lamap*Ae_ss*psiae_ss + (1-lamap)*la_ss)^(alphaep))^(1/alphaep-1)*(lamap*Ae_ss*psiae_ss + (1-lamap)*la_ss)^(alphaep-1)] ;
% InitialGuess = [5;1];
% Options = optimset('Display','off');
% XY = fsolve(F, InitialGuess, Options);
% ke_ss = XY(1);
% aa_ss = XY(2);
% 
% 
% % [ke_ss,fval,exitflag]=fzero(@(ke_ss)( rk_ss - alephep*lamep^(1/eoskle)*ae_ss*(alephep* ((lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(1/sigkp))^(alphaep) + (1-alephep)*aa_ss*(lamap*Ae_ss + (1-lamap)*la_ss)^(alphaep))^(1/alphaep-1) *((lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(1/sigkp))^(alphaep-1)*((lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(1/sigkp-1))*ke_ss^(sigkp-1) ), 5);
% % 
% % if exitflag <1
% %     indicate the SS computation was not successful; this would also be detected by Dynare
% %     setting the indicator here shows how to use this functionality to
% %     filter out parameter draws
% %     check=1; %set failure indicator
% %     return; %return without updating steady states
% % end
% 
% ie_ss = (lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(1/sigkp) ;
% 
% 
% ye_ss = ae_ss*ie_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*la_ss)^(1-alphaep) ;
% 
% mpke_ss = lamep^(1/eoskle)*ae_ss*alphaep*(lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp-1)*ke_ss^(sigkp-1) ;
% mple_ss = (1-lamep)^(1/eoskle)*ae_ss*alphaep*(lamep^(1/eoskle)*ke_ss^sigkp + (1-lamep)^(1/eoskle)*le_ss^sigkp)^(alphaep/sigkp-1)*le_ss^(sigkp-1) ;
% mpla_ss = (1-alphaep)*ae_ss*ie_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*la_ss)^(-alphaep)*aa_ss ;
% mpAe_ss = (1-alphaep)*ae_ss*ie_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*la_ss)^(-alphaep)*psiae_ss ;


ye_ss     =  (((1)/(betap)-(1-deltap))*(tq_ss)/(alphaep))^(-(alphaep)/(1-alphaep))*(aa_ss*le_ss+Ae_ss*psiae_ss) ;
ke_ss      =  (ye_ss)/(((1)/(betap)-(1-deltap))*(tq_ss)/(alphaep));



% ke_ss = (alphaep*ae_ss*rk_ss*(Ae_ss*psiae_ss + aa_ss*le_ss)^(1-alphaep))^(1/(alphaep-1)) ;
% 
% ye_ss = ae_ss*ke_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*le_ss)^(1-alphaep) ;
mpke_ss = alphaep*ae_ss*ke_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*le_ss)^(1-alphaep)/ke_ss ;
mple_ss = (1-alphaep)*aa_ss*ae_ss*ke_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*le_ss)^(-alphaep) ;
mpAe_ss = (1-alphaep)*psiae_ss*ae_ss*ke_ss^(alphaep)*(Ae_ss*psiae_ss + aa_ss*le_ss)^(-alphaep) ;


xe_ss = ke_ss*deltap ; 
mpkcheck = rk_ss - mpke_ss ;
gdpe_ss = ye_ss ;
%%%%%%%%%%%%
%%Automation - Germany
%%%%%%%%%%%%
PsiXAG_ss = 1.00;
Ag_ss = 0.350 ;

rhoAmp = 0.016 ;%0.03
rhoAsp = rhoAmp ;

%Am_ss = Ag_ss/(lm_ss+hrss_ss) ;
%As_ss = Am_ss ;
Am_ss = Ag_ss;%*lm_ss/(lm_ss+hrss_ss) ;
As_ss = Ag_ss;%*hrss_ss/(lm_ss+hrss_ss) ; 
qam_ss = Am_ss*(PsiXAG_ss - (1-rhoAmp))/((1-qvm_ss)*vm_ss) ;
%qam_ss = (Am_ss*PsiXA_ss*rhoAmp)/((1-qvm_ss)*vm_ss) ;

num_ss = qam_ss*(1-qvm_ss)*vm_ss ; % rhoAep*Ae_ss
qas_ss = As_ss*(PsiXAG_ss - (1-rhoAsp))/((1-qvs_ss)*vs_ss) ;
%qas_ss = (As_ss*PsiXA_ss*rhoAsp)/((1-qvs_ss)*vs_ss) ;
nus_ss = qas_ss*(1-qvs_ss)*vs_ss ; % rhoAep*Ae_ss


psiag_ss = 1 ;

etaamp = 1;
etaemp = 1;
etaasp = 1;
etaesp = 1;

eosalag = 5 ;
sigagp = (eosalag-1)/eosalag ;
sigla = 0.4 ;
eosms = 4;
chimsp = 1;%(eosms - 1)/eosms ;

taumsp = (lm_ss+psiag_ss*Am_ss)/(hrss_ss+lm_ss+psiag_ss*Am_ss+psiag_ss*As_ss) ;
%LAM_ss = ((sigla)^(1/eosalag)*lm_ss^sigagp+(1-sigla)^(1/eosalag)*Am_ss^sigagp)^(1/sigagp);
%LAS_ss = ((sigla)^(1/eosalag)*hrss_ss^sigagp+(1-sigla)^(1/eosalag)*As_ss^sigagp)^(1/sigagp) ;
%LAM_ss = ((sigla)^(1/eosalag)*lm_ss+(1-sigla)^(1/eosalag)*psiag_ss*Am_ss);
%LAS_ss = ((sigla)^(1/eosalag)*hrss_ss+(1-sigla)^(1/eosalag)*psiag_ss*As_ss) ;


%lbrms_ss = ( taumsp^(1/eosms)*(LAM_ss)^(chimsp) + (1-taumsp)^(1/eosms)*(LAS_ss)^(chimsp))^(1/chimsp) ;
%lbrms_ss = ( taumsp^(1/eosms)*(LAM_ss)^((eosms - 1)/eosms) + (1-taumsp)^(1/eosms)*(LAS_ss)^((eosms - 1)/eosms))^(eosms/(eosms - 1)) ;
%lbrms_ss = ( taumsp^(1/eosms)*(Am_ss*psiag_ss + lm_ss)^(chimsp) + (1-taumsp)^(1/eosms)*(As_ss*psiag_ss + hrss_ss)^(chimsp))^(1/chimsp) ;

lbrms_ss = lm_ss+ psiag_ss*Am_ss + hrss_ss +psiag_ss*As_ss ; %%%%%%%%EITHER lm_ss*Am_ss or lm_ss + Am_ss???

rkg_ss = (1/betagp - (1-deltagp)) ;
alephgp         =   0.35; 
etagp     =   0.40 ;

eosklh = 1/1.6 ;
nup = (eosklh-1)/eosklh; 
%eosklh = 0.09 ;
%nup = 1/eosklh; 
eoskll = 1/0.4;
alphagp =  (eoskll-1)/eoskll ;
psiag_ss = 1;
AG_SS = 2 ;
ag_ss = 1;
[kg_ss,fval,exitflag]=fzero(@(kg_ss)( rkg_ss - AG_SS*ag_ss*alephgp*etagp^(1/eosklh)*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup-1)*kg_ss^(nup-1) ), 5);

if exitflag <1
    %indicate the SS computation was not successful; this would also be detected by Dynare
    %setting the indicator here shows how to use this functionality to
    %filter out parameter draws
    check=1; %set failure indicator
    return; %return without updating steady states
end


% ig_ss = (etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(1/nup) ;
% yg_ss = AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp) ;
% mpkg_ss =AG_SS*alephgp*etagp^(1/eosklh)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(lbrms_ss)^(alphagp))^(1/alphagp-1)*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup-1)*kg_ss^(nup-1) ; 
% mplg_ss =AG_SS*alephgp*(1-etagp)^(1/eosklh)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(  lbrms_ss)^(1/alphagp-1)*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup-1)*hrsg_ss^(nup-1) ; 
% 
% mplm_ss = AG_SS*(1-alephgp)*taumsp^(1/eosms)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(  lbrms_ss)^(1/alphagp-1)*(  (1-taumsp)^(1/eosms)*(As_ss*psiag_ss + hrss_ss)^(chimsp))^(alphagp/chimsp-1) ;
% mpls_ss = AG_SS*(1-alephgp)*(1-taumsp)^(1/eosms)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(  lbrms_ss)^(1/alphagp-1)*(  (1-taumsp)^(1/eosms)*(As_ss*psiag_ss + hrss_ss)^(chimsp))^(alphagp/chimsp-1) ;
% 
% mpAm_ss =AG_SS* psiag_ss*(1-alephgp)*taumsp^(1/eosms)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(  lbrms_ss)^(1/alphagp-1)*(  (1-taumsp)^(1/eosms)*(As_ss*psiag_ss + hrss_ss)^(chimsp))^(alphagp/chimsp-1) ;
% mpAs_ss =AG_SS* psiag_ss*(1-alephgp)*(1-taumsp)^(1/eosms)*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*(  lbrms_ss)^(1/alphagp-1)*(  (1-taumsp)^(1/eosms)*(As_ss*psiag_ss + hrss_ss)^(chimsp))^(alphagp/chimsp-1) ;

ig_ss = (etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(1/nup) ;
yg_ss = AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp) ;
mpkg_ss = AG_SS*ag_ss*alephgp*etagp^(1/eosklh)*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup-1)*kg_ss^(nup-1) ;
mplg_ss = AG_SS*ag_ss*alephgp*(1-etagp)^(1/eosklh)*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup-1)*hrsg_ss^(nup-1) ;

mplm_ss = (1-alephgp)*AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*lbrms_ss^(alphagp-1) ;
mpls_ss = (1-alephgp)*AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*lbrms_ss^(alphagp-1) ;

mpAm_ss = (1-alephgp)*AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*lbrms_ss^(alphagp-1) ;
mpAs_ss = (1-alephgp)*AG_SS*ag_ss*(alephgp*(etagp^(1/eosklh)*kg_ss^(nup) + (1-etagp)^(1/eosklh)*hrsg_ss^(nup))^(alphagp/nup) + (1-alephgp)*lbrms_ss^alphagp)^(1/alphagp-1)*lbrms_ss^(alphagp-1) ;


gdpg_ss = yg_ss  ;
xg_ss     =  (deltagp)/(kappaxp)*kg_ss; 
kappaebarp =  sharestartbg*kappacompp*ye_ss/(qve_ss);     
kappavep   =  (kappacompp*ye_ss-kappaebarp*qve_ss)/(ve_ss);
kappagbarp =  sharestartbg*kappacompp*yg_ss/(qvg_ss);     
kappavgp   =  (kappacompp*yg_ss-kappagbarp*qvg_ss)/(vg_ss);
kappambarp =  sharestartbg*kappacompp*yg_ss/(qvm_ss);     
kappavmp   =  (kappacompp*yg_ss-kappambarp*qvm_ss)/(vm_ss);
kappasbarp =  sharestartbg*kappacompp*yg_ss/(qvs_ss);     
kappavsp   =  (kappacompp*yg_ss-kappasbarp*qvs_ss)/(vs_ss);


kappave_ss          = kappavep*ve_ss;
kappavh_diffcont_ss = kappavep; 
kappavh_difflag_ss  = 0;

kappavg_ss          = kappavgp*vg_ss;
kappavf_diffcont_ss = kappavgp; 
kappavf_difflag_ss  = 0;

kappavm_ss          = kappavmp*vm_ss;
kappavm_diffcont_ss = kappavmp; 
kappavm_difflag_ss  = 0;

kappavs_ss          = kappavsp*vs_ss;
kappavs_diffcont_ss = kappavsp; 
kappavs_difflag_ss  = 0;

phivep = 3 ;
phivgp = 3 ;
phivmp = 3 ;
phivsp = 3 ;


wwe_ss = mple_ss ;
wwg_ss = mplg_ss ;
wwm_ss = mplm_ss ;
wws_ss = mpls_ss ;

phi0p  = wwe_ss/he_ss^phip ;
phi0gp = wwg_ss/hg_ss^phip ;
phi0mp = wwm_ss/hm_ss^phip ;
phi0sp = wws_ss/hs_ss^phip ;

Jee_ss      =  (kappavep)/(qve_ss)+kappaebarp;
Jeg_ss      =  (kappavgp)/(qvg_ss)+kappagbarp;
Jem_ss      =  (kappavmp)/(qvm_ss)+kappambarp;
Jes_ss      =  (kappavsp)/(qvs_ss)+kappasbarp;

kappaAep = 0.9*mpAe_ss;
Jae_ss = (mpAe_ss - kappaAep)/(1-(1-rhoAep)*betap) ;
Jve_ss = (-kappaebarp + Jee_ss*qve_ss +  betap*(1-qve_ss)*Jae_ss*qae_ss)/(1 - betap*(1-qve_ss)*(1-qae_ss)) ;

xstare_ss = Jae_ss - Jve_ss ;
xbare = xstare_ss/qae_ss ;
ebare = Jve_ss/nue_ss ;

kappaAmp = 0.85*mpAm_ss ;
Jam_ss = (mpAm_ss - kappaAmp)/(1-(1-rhoAmp)*betagp) ;
Jvm_ss = (-kappambarp + Jem_ss*qvm_ss +  betagp*(1-qvm_ss)*Jam_ss*qam_ss)/(1 - betagp*(1-qvm_ss)*(1-qam_ss)) ;

xstarm_ss = Jam_ss - Jvm_ss ;
xbarm = xstarm_ss/qam_ss ;
ebarm = Jvm_ss/num_ss ;

kappaAsp = kappaAmp; 
Jas_ss = (mpAs_ss - kappaAsp)/(1-(1-rhoAsp)*betagp) ;
Jvs_ss = (-kappasbarp + Jes_ss*qvs_ss +  betagp*(1-qvs_ss)*Jas_ss*qas_ss)/(1 - betagp*(1-qvs_ss)*(1-qas_ss)) ;

xstars_ss = Jas_ss - Jvs_ss ;
xbars = xstars_ss/qas_ss ;
ebars = Jvs_ss/nus_ss ;

%%Germany
qag_ss = 0 ;
Jag_ss = 0 ;
nug_ss = qag_ss*(1-qvg_ss)*vg_ss ;
Jvg_ss = (-kappagbarp + Jeg_ss*qvg_ss +  betagp*(1-qvg_ss)*Jag_ss*qag_ss)/(1 - betagp*(1-qvg_ss)*(1-qag_ss)) ;

ebarg = Jvg_ss/nug_ss ;




%we_ss     =  wwe_ss-(1-(1-rhonep)*betap)*Jee_ss/he_ss; 
%ws_ss     =  wws_ss-(1-(1-rhonsp)*betagp)*Jes_ss/hg_ss;
%wm_ss     =  wwm_ss-(1-(1-rhonmp)*betagp)*Jem_ss/he_ss;
wg_ss     =  wwg_ss-(1-(1-rhongp)*betagp)*Jeg_ss/hg_ss;

we_ss = wwe_ss + (betap*(rhonep*Jve_ss + (1-rhonep)*Jee_ss) - Jee_ss)/he_ss ;
%wg_ss = wwg_ss + (betagp*(rhongp*Jvg_ss + (1-rhongp)*Jeg_ss) - Jeg_ss)/hg_ss ;
wm_ss = wwm_ss + (betagp*(rhonmp*Jvm_ss + (1-rhonmp)*Jem_ss) - Jem_ss)/hm_ss ;
ws_ss = wws_ss + (betagp*(rhonsp*Jvs_ss + (1-rhonsp)*Jes_ss) - Jes_ss)/hs_ss ;

%%check varthetaj

ube_rr = 0.2 ;
ubg_rr = 0.3 ;
ubs_rr = 0.3 ;
ubm_rr = 0.45 ;

ubh = ube_rr*we_ss*he_ss ;
ubg = ubg_rr*wg_ss*hg_ss ;
ubs = ubs_rr*ws_ss*hs_ss ;
ubm = ubm_rr*wm_ss*hm_ss ;


ube_ss = ubh ;
ubm_ss = ubm ;
ubg_ss = ubg ;
ubs_ss = ubs ;


% ubm3a = zetae_ss*(we_ss + betap*((ne_ss)*we_ss + uee_ss*ube_ss)) ;
% ubm3b = (1-zetae_ss)*(ube_ss + betap*(zetae_ss*we_ss + (1-zetae_ss)*ube_ss)) ;
% ubm3c = (zetam_ss*(wm_ss+betap*(nm_ss)*wm_ss) + (1-zetam_ss)*(betap*zetam_ss*wm_ss)) ;
% ubm3d = zetam_ss*betap*uem_ss + (1-zetam_ss)*(1+ (1-zetam_ss)*betap) ;
% ubm3 = (ubm3a + ubm3b - ubm3c)/ubm3d ;
% ubm= ubm3 ;
% %ubm_rr = ubm/wm_ss ;
% ubm_ss = ubm ;

He_ss      = (we_ss*he_ss-ubh-phi0p/(1+phip)*he_ss^(1+phip))/(1-(1-rhonep)*(1-zetae_ss)*betap);
Hg_ss      = (wg_ss*hg_ss-ubg-phi0gp/(1+phigp)*hg_ss^(1+phigp))/(1-(1-rhongp)*(1-zetag_ss)*betagp);
Hs_ss      = (ws_ss*hg_ss-ubs-phi0sp/(1+phigp)*hs_ss^(1+phigp))/(1-(1-rhonsp)*(1-zetas_ss)*betagp);
Hm_ss      = (wm_ss*hm_ss-ubm-phi0mp/(1+phip)*hm_ss^(1+phip))/(1-(1-rhonmp)*(1-zetam_ss)*betap);

% WE_ss = (we_ss + betap*(ne_ss*we_ss + (uee_ss)*ube_ss)) ;
% UE_ss = (ube_ss + betap*((zetae_ss)*(we_ss) + (1-(zetae_ss))*ube_ss)) ;
% WM_ss = (wm_ss + betap*(nm_ss*wm_ss + (uem_ss)*ubm_ss)) ;
% UM_ss = (ubm_ss + betap*((zetam_ss)*(wm_ss) + (1-(zetam_ss))*ubm_ss)) ;

WE_ss = (we_ss + betap*((1-rhonep)*we_ss + rhonep*ube_ss)) ;
UE_ss = (ube_ss + betap*((zetae_ss)*(we_ss) + (1-(zetae_ss))*ube_ss)) ;
WM_ss = (wm_ss + betap*((1-rhonmp)*wm_ss + rhonmp*ubm_ss)) ;
UM_ss = (ubm_ss + betap*((zetam_ss)*(wm_ss) + (1-(zetam_ss))*ubm_ss)) ;



ec_ss =(zetam_ss*WM_ss + (1-zetam_ss)*UM_ss) - ( zetae_ss*WE_ss + (1-zetae_ss)*UE_ss) ;
omegaec = 2*ec_ss*(varphiem_ss/varphiee_ss)^(-2) ;

%varthetaep = He_ss/(Jee_ss - Jve_ss + He_ss);
%varthetasp = Hs_ss/(Jes_ss - Jvs_ss + Hs_ss) ;
%varthetamp = Hm_ss/(Jem_ss - Jvm_ss + Hm_ss) ;

varthetaep = He_ss/(Jee_ss + He_ss);
varthetagp = Hg_ss/(Jeg_ss + Hg_ss) ;
varthetasp = Hs_ss/(Jes_ss + Hs_ss) ;
varthetamp = Hm_ss/(Jem_ss + Hm_ss) ;

xila_ss            = 0;
xila_difg_ss       = 0;
xila_difflag_ss    = 0;
xika_ss            = 0;
xiko_difg_ss       = 0;
xiko_difflag_ss    = 0;

rer_ss    =  1; 
pee_ss    =  1; 
peg_ss    =  1;
pgg_ss    =  1;
pge_ss    =  1;
tot_ss    =  1;



%%%%%%%%%%
nnp = 24/(24+52) ; %Ger WA POP 2018= 52 million Pol=24m approx

dstargdp= -1.16358209/100; 
bbarp     = dstargdp;
dstargdpe_ss =  bbarp;
tbalagggdpe_ss   =  (dstargdpe_ss-(1+r_ss)*dstargdpe_ss);
tbalagge_ss = tbalagggdpe_ss*gdpe_ss ;
tbalaggg_ss = -tbalagge_ss*nnp/(1-nnp) ;
dstare_ss = dstargdpe_ss*gdpe_ss ;
dstarg_ss =  -dstare_ss*nnp/(1-nnp) ;
%%%%%%%%%

% tbalagggdpg_ss = 0.06 ;
% tbalaggg_ss = tbalagggdpg_ss*gdpg_ss ;
% dstarg_ss = tbalaggg_ss/(-rg_ss) ;
% dstare_ss = -dstarg_ss*(1-nnp)/nnp ;
% dstargdpe_ss = dstare_ss/gdpe_ss ;
% tbalagge_ss = -tbalaggg_ss*(1-nnp)/nnp ;
% tbalagggdpe_ss   =  (dstargdpe_ss-(1+r_ss)*dstargdpe_ss);
% tbala_ss = yog_ss ;
% tbal_ss = tbalagge_ss - tbala_ss ;
% tbalagdpe_ss = tbala_ss/gdpe_ss ;
% tbalgdpe_ss = tbal_ss/gdpe_ss ;

% tbalagggdpg_ss = 0.006 ;
% tbalagggdpe_ss = -tbalagggdpg_ss*(1-nnp)/nnp ;
% tbalagge_ss = tbalagggdpe_ss*gdpe_ss ;
% dstare_ss = tbalagge_ss/(-r_ss) ;
% tbala_ss = yog_ss ;
% tbal_ss = tbalagge_ss - tbala_ss ;
% dstarg_ss =  -dstare_ss*nnp/(1-nnp) ;
% dstargdpe_ss = dstare_ss/gdpe_ss ;
% tbalaggg_ss = -tbalagge_ss*nnp/(1-nnp) ;
% tbalgdpe_ss = tbal_ss/gdpe_ss ;
% tbalagdpe_ss = tbala_ss/gdpe_ss ;

ratiogedpe     = 0.15 ; %0.30
ratiogxgdpe = 0.02 ;
ge_ss = ratiogedpe*gdpe_ss ;

ratioggdpg = 0.15 ;
geg_ss = ratioggdpg*gdpg_ss ;
 
gxe_ss = ratiogxgdpe*ye_ss ; 
gc_ss = ge_ss - gxe_ss ;% - poe_ss*yoe_ss ;%- ubh*uee_ss ;



ratiogxyf = 0.01 ;
gxg_ss = ratiogxyf*yg_ss ;


ratiogxyf = 0.03 ;
gxg_ss = ratiogxyf*yg_ss ;

taxg_ss = geg_ss - rg_ss*dstarg_ss ;

gcg_ss = geg_ss - gxg_ss ;

taxe_ss = ge_ss - r_ss*dstare_ss ;

remitoverwmlm = 0.05 ;

remit_ss = remitoverwmlm*wm_ss ;

bg_ss = gxe_ss + gxg_ss ;

cm_ss = wm_ss*lm_ss - remit_ss - (nm_ss+uuem_ss)/(1+nm_ss+uuem_ss)*taxg_ss ;

%remit_ss = (wm_ss*lm_ss)/((le_ss+la_ss)*we_ss) ;
rhoremit = 0.99 ;
varremit = remit_ss*(we_ss/(wm_ss ))^(rhoremit) ; 


ce_ss = gdpe_ss - xe_ss - kappaebarp*qve_ss - kappave_ss  - xila_ss - xika_ss - ge_ss - tbalagge_ss - kappaAep*Ae_ss - etaaep/(1+etaaep)*qae_ss*xstare_ss*(1-qve_ss)*ve_ss - etaeep/(1+etaeep)*nue_ss*Jve_ss;
cg_ss = gdpg_ss - xg_ss - kappagbarp*qvg_ss - kappavg_ss - kappasbarp*qvs_ss - kappavs_ss  - kappambarp*qvm_ss - kappavm_ss -cm_ss - geg_ss - tbalaggg_ss - kappaAmp*Am_ss - etaamp/(1+etaamp)*qam_ss*xstarm_ss*(1-qvm_ss)*vm_ss - etaemp/(1+etaemp)*num_ss*Jvm_ss - kappaAsp*As_ss - etaasp/(1+etaasp)*qas_ss*xstars_ss*(1-qvs_ss)*vs_ss - etaesp/(1+etaesp)*nus_ss*Jvs_ss;


%mue_ss = (ce_ss-phi0p/(1+phip)*he_ss^(1+phip)-phi0mp/(1+phip)*hm_ss^(1+phip))^(-sigmap);
mue_ss = (ce_ss)^(-sigmap);
%mug_ss = (cg_ss-phi0gp/(1+phigp)*hg_ss^(1+phigp)-phi0sp/(1+phigp)*hs_ss^(1+phigp))^(-sigmap); 
mug_ss = (cg_ss)^(-sigmap);


% adjustment costs
iotax_ss           = kappaxp*xe_ss;
iotax_diffcont_ss  = kappaxp;
iotax_difflag_ss   = 0;

iotaxg_ss           = kappaxp*xg_ss;
iotaxg_diffcont_ss  = kappaxp;
iotaxg_difflag_ss   = 0;       

auch = (ce_ss)+(xe_ss)+ kappaebarp*(qve_ss)+ kappave_ss + ge_ss + xila_ss + xika_ss  + kappaAep*Ae_ss + etaaep/(1+etaaep)*qae_ss*xstare_ss*(1-qve_ss)*ve_ss + etaeep/(1+etaeep)*nue_ss*Jve_ss ;
aucf = (cg_ss)+(xg_ss)+ kappagbarp*(qvg_ss)+ kappavg_ss + kappasbarp*qvs_ss + kappavs_ss  +  kappambarp*(qvm_ss)+kappavm_ss +  geg_ss + cm_ss + kappaAmp*Am_ss + etaamp/(1+etaamp)*qam_ss*xstarm_ss*(1-qvm_ss)*vm_ss + etaemp/(1+etaemp)*num_ss*Jvm_ss + kappaAsp*As_ss + etaasp/(1+etaasp)*qas_ss*xstars_ss*(1-qvs_ss)*vs_ss + etaesp/(1+etaesp)*nus_ss*Jvs_ss ;


gammap = 0.35 ;
vp  =  1 - (1-nnp)*gammap;


gammagp = (gdpe_ss - vp*auch)/((1-nnp)/nnp*nnp*aucf) ;
vgp = nnp*gammagp ;

psigc_ss = 1 ;
psigcg_ss = 1;

psigc_ss = 1 ;
psigcg_ss = 1;
psiag_ss =1;
psiae_ss =1;
gm_ss = 1;

AGAE_ss = (As_ss+Am_ss)/Ae_ss ;

% assign steady state values
aa_t=log(ae_ss);
ae_t=log(ae_ss);
Ae_t=log(Ae_ss);
ag_t=log(ag_ss);
Am_t=log(Am_ss);
As_t=log(As_ss);
ce_t=log(ce_ss);
cg_t=log(cg_ss);
cm_t=log(cm_ss);
dstare_t=dstare_ss;
dstarg_t=dstarg_ss;
dstargdpe_t=dstargdpe_ss;
g_t=log(g_ss);
gc_t=log(gc_ss);
gcg_t=log(gcg_ss);
gdpe_t=log(gdpe_ss);
gdpg_t=log(gdpg_ss);
ge_t=log(ge_ss);
geg_t=log(geg_ss);
gg_t=log(gg_ss);
gxe_t=log(gxe_ss);
gxg_t=log(gxg_ss);
he_t=log(he_ss);
He_t=log(He_ss);
hg_t=log(hg_ss);
Hg_t=log(Hg_ss);
Hm_t=log(Hm_ss);
hm_t=log(hm_ss);
hrse_t=log(hrse_ss);
hrsg_t=log(hrsg_ss);
hrss_t=log(hrss_ss);
Hs_t=log(Hs_ss);
hs_t=log(hs_ss);
ig_t=log(ig_ss);
iotax_diffcont_t=iotax_diffcont_ss;
iotax_difflag_t=iotax_difflag_ss;
iotax_t=iotax_ss;
iotaxg_diffcont_t=iotaxg_diffcont_ss;
iotaxg_difflag_t=iotaxg_difflag_ss;
iotaxg_t=iotaxg_ss;
Jae_t=log(Jae_ss);
Jam_t=log(Jam_ss);
Jas_t=log(Jas_ss);
Jee_t=log(Jee_ss);
Jeg_t=log(Jeg_ss);
Jem_t=log(Jem_ss);
Jes_t=log(Jes_ss);
Jve_t=log(Jve_ss);
Jvm_t=log(Jvm_ss);
Jvs_t=log(Jvs_ss);
kappave_t=kappave_ss;
kappavf_diffcont_t=kappavf_diffcont_ss;
kappavf_difflag_t=kappavf_difflag_ss;
kappavg_t=kappavg_ss;
kappavm_t=kappavm_ss;
kappavs_t=kappavs_ss;
ke_t=log(ke_ss);
kg_t=log(kg_ss);
la_t=log(la_ss);
lambdae_t=log(lambdae_ss);
lbrms_t=log(lbrms_ss);
le_t=log(le_ss);
lm_t=log(lm_ss);
me_t=log(me_ss);
mg_t=log(mg_ss);
mm_t=log(mm_ss);
mpAe_t=log(mpAe_ss);
mpAm_t=log(mpAm_ss);
mpAs_t=log(mpAs_ss);
mpkg_t=log(mpkg_ss);
%mpla_t=log(mpla_ss);
mple_t=log(mple_ss);
mplg_t=log(mplg_ss);
mplm_t=log(mplm_ss);
mpls_t=log(mpls_ss);
ms_t=log(ms_ss);
mue_t=log(mue_ss);
mug_t=log(mug_ss);
ne_t=log(ne_ss);
ng_t=log(ng_ss);
nm_t=log(nm_ss);
ns_t=log(ns_ss);
nue_t=log(nue_ss);
num_t=log(num_ss);
nus_t=log(nus_ss);
pge_t=log(pge_ss);
pgg_t=log(pgg_ss);
pee_t=log(pee_ss);
peg_t=log(peg_ss);
psie_t=log(psie_ss);
psigc_t=log(psigc_ss);
psigcg_t=log(psigcg_ss);
PsiXA_t=log(PsiXA_ss);
PsiXAG_t=log(PsiXAG_ss);
qae_t=log(qae_ss);
qam_t=log(qam_ss);
qas_t=log(qas_ss);
qve_t=log(qve_ss);
qvg_t=log(qvg_ss);
qvm_t=log(qvm_ss);
qvs_t=log(qvs_ss);
r_t=r_ss;
remit_t=log(remit_ss);
rer_t=log(rer_ss);
rg_t=rg_ss;
rk_t=log(rk_ss);
rshock_t=(rshock_ss);
taxe_t=log(taxe_ss);
taxg_t=log(taxg_ss);
tbalagge_t=tbalagge_ss;
tbalaggg_t=(tbalaggg_ss);
tbalagggdpe_t=tbalagggdpe_ss;
thetae_t=log(thetae_ss);
thetag_t=log(thetag_ss);
thetam_t=log(thetam_ss);
thetas_t=log(thetas_ss);
tot_t=log(tot_ss);
tq_t=log(tq_ss);
tqg_t=log(tqg_ss);
ube_t=log(ube_ss);
ubg_t=log(ubg_ss);
ubm_t=log(ubm_ss);
ubs_t=log(ubs_ss);
ue_t=log(ue_ss);
ugg_t=log(ugg_ss);
ugs_t=log(ugs_ss);
ug_t=log(ug_ss);
uee_t=log(uee_ss);
uem_t=log(uem_ss);
utildee_t=log(utildee_ss);
utildegg_t=log(utildegg_ss);
utildegs_t=log(utildegs_ss);
utildeg_t=log(utildeg_ss);
utildeee_t=log(utildeee_ss);
utildeem_t=log(utildeem_ss);
ve_t=log(ve_ss);
vg_t=log(vg_ss);
vm_t=log(vm_ss);
vs_t=log(vs_ss);
we_t=log(we_ss);
wg_t=log(wg_ss);
wm_t=log(wm_ss);
ws_t=log(ws_ss);
wwe_t=log(wwe_ss);
wwg_t=log(wwg_ss);
wwm_t=log(wwm_ss);
wws_t=log(wws_ss);
xe_t=log(xe_ss);
xg_t=log(xg_ss);
xstare_t=log(xstare_ss);
xstarm_t=log(xstarm_ss);
xstars_t=log(xstars_ss);
ye_t=log(ye_ss);
yg_t=log(yg_ss);
zetae_t=log(zetae_ss);
zetag_t=log(zetag_ss);
zetam_t=log(zetam_ss);
zetas_t=log(zetas_ss);

ec_t = log(ec_ss) ;


ube_t = log(ube_ss) ;
ubg_t = log(ubg_ss) ;
ubm_t = log(ubm_ss) ;
ubs_t = log(ubs_ss) ;

psiag_t = log(psiag_ss) ;
psiae_t = log(psiae_ss) ;
gm_t = log(gm_ss) ;

nug_t = log(nug_ss) ;
Jvg_t = log(Jvg_ss) ;

dyg	= 0 ;
dxg	= 0 ;
dgcg = 0 ;
dgxg= 0 ;
dye	= 0 ;
dce	= 0 ;
dxe	= 0 ;
dgce = 0 ;
dnm = 0 ;

AGAE_t = log(AGAE_ss) ;
lbg_t = log(lbg_ss) ;
%% end own model equations


for iter = 1:length(M_.params) %update parameters set in the file
  eval([ 'M_.params(' num2str(iter) ') = ' M_.param_names(iter,:) ';' ])
end

NumberOfEndogenousVariables = M_.orig_endo_nbr; %auxiliary variables are set automatically
for ii = 1:NumberOfEndogenousVariables
  varname = deblank(M_.endo_names(ii,:));
  eval(['ys(' int2str(ii) ') = ' varname ';']);
end
